import type { TachyonPage } from 'tachyon-next-types';
import { defaultPageviewTracking } from 'tachyon-page-utils';
import { Color, CoreText } from 'twitch-core-ui';

/**
 * Health check page renderer. If this page response fails this instance of
 * Tomorrow will stop receiving traffic.
 *
 * The rendered content does is not consumed as part of the health check which
 * only relies on the response status code. In the future we may want to make this
 * into a table of status checks so that a human looking at it could see why we
 * got an unexpected status code.
 *
 * NOTE: Exercising core ui here is intentional. This route is already rendering all of _app
 * so it's meant to exercise as much of the non-remote functionality as possible.
 *
 * The usage of core-ui here isn't meant to appeal to humans, just to execute core-ui code paths.
 */
export const HealthCheck: TachyonPage = () => (
  <main>
    <CoreText color={Color.Base}>ok</CoreText>
  </main>
);

HealthCheck.displayName = 'HealthCheck';
HealthCheck.pageviewTracking = defaultPageviewTracking;

/**
 * If run on server will reach into context to set a no-store cache header.
 *
 * Returns an empty object since HealthCheck requires no context.
 */
HealthCheck.getInitialProps = ({ res }) => {
  if (res) {
    // Do not store the request or response in non-volatile memory.
    // See section 5.2.1.5 https://tools.ietf.org/html/rfc7234#section-5.2
    res.setHeader('Cache-Control', 'no-store');
  }

  // Next requires us to return some initial props even if we don't really
  // have any.
  return {};
};
