import type { FC, FormEvent } from 'react';
import { useState } from 'react';
import { useIntl } from 'tachyon-intl';
import {
  Color,
  Display,
  FormGroup,
  JustifyContent,
  Layout,
  TextArea,
} from 'twitch-core-ui';

export const MAX_DESCRIPTION_LENGTH = 5000;

type AppealDescriptionProps = {
  onDescriptionChange: (value: string) => void;
  value?: string;
};

export const AppealDescription: FC<AppealDescriptionProps> = ({
  onDescriptionChange,
  value,
}) => {
  const { formatMessage } = useIntl();
  const [descriptionLength, setDescriptionLength] = useState(0);

  const onInputChange = (evt: FormEvent<HTMLTextAreaElement>) => {
    const inputValue = evt.currentTarget.value;
    onDescriptionChange(inputValue);
    setDescriptionLength(inputValue.length);
  };

  return (
    <Layout margin={{ y: 2 }}>
      <FormGroup
        error={value === ''}
        errorMessage={formatMessage('Description can not be empty', 'Moonbase')}
        label={'Tell us why you think this was made in error'}
      >
        <TextArea
          maxLength={MAX_DESCRIPTION_LENGTH}
          onChange={onInputChange}
          value={value}
        />
      </FormGroup>
      <Layout
        color={Color.Alt2}
        display={Display.Flex}
        fullWidth
        justifyContent={JustifyContent.End}
        padding={{ top: 0.5 }}
      >
        {`${descriptionLength}/${MAX_DESCRIPTION_LENGTH}`}
      </Layout>
    </Layout>
  );
};

AppealDescription.displayName = 'AppealDescription';
