import Faker from 'faker';
import {
  createShallowWrapperFactory,
  mockChangeEvent,
} from 'tachyon-test-utils';
import { FormGroup, TextArea } from 'twitch-core-ui';
import { AppealDescription } from '.';

describe(AppealDescription, () => {
  const setup = createShallowWrapperFactory(AppealDescription, () => ({
    onDescriptionChange: (_: string) => null,
    value: Faker.lorem.sentence(),
  }));

  it('renders as expected', () => {
    const { wrapper } = setup();
    expect(wrapper.find(FormGroup)).toExist();
    expect(wrapper.find(TextArea)).toExist();
  });

  it('calls onDescriptionChange when user types in textbox', () => {
    const mockOnDescriptionChange = jest.fn();
    const { wrapper } = setup({ onDescriptionChange: mockOnDescriptionChange });
    wrapper.find(TextArea).props().onChange?.(mockChangeEvent('some text'));
    expect(mockOnDescriptionChange).toHaveBeenCalledTimes(1);
  });
});
