import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import {
  AlignItems,
  Button,
  CoreText,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  TextAlign,
  Title,
  TitleSize,
} from 'twitch-core-ui';
import { NAVBAR_HEIGHT } from '../../../../common';

export type ConfirmationPageProps = {
  onClose: () => void;
};

export const ConfirmationPage: FC<ConfirmationPageProps> = ({ onClose }) => {
  const { formatMessage } = useIntl();

  return (
    <Layout
      alignItems={AlignItems.Center}
      as="main"
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      justifyContent={JustifyContent.Center}
      minHeight={`calc(100vh - ${NAVBAR_HEIGHT})`}
      padding={3}
      textAlign={TextAlign.Center}
    >
      <Title size={TitleSize.Large}>
        {formatMessage('Your appeal has been submitted.', 'Moonbase')}
      </Title>
      <Layout margin={{ top: 2 }}>
        <CoreText>
          {formatMessage(
            'The enforcement and any associated penalties will remain on your account until one of our representatives reviews your case.',
            'Moonbase',
          )}
        </CoreText>
      </Layout>
      <Layout margin={{ bottom: 2, top: 1, x: 2 }}>
        <CoreText>
          {formatMessage(
            'If you need to submit an appeal for a different enforcement, you may log back in and complete the form again.',
            'Moonbase',
          )}
        </CoreText>
      </Layout>
      <Button onClick={onClose}>{formatMessage('Close', 'Moonbase')}</Button>
    </Layout>
  );
};
ConfirmationPage.displayName = 'ConfirmationPage';
