import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Button, CoreText, Title } from 'twitch-core-ui';
import { ConfirmationPage } from '.';

describe(ConfirmationPage, () => {
  const setup = createShallowWrapperFactory(ConfirmationPage, () => ({
    onClose: () => null,
  }));

  it('renders as expected', () => {
    const { wrapper } = setup();
    expect(wrapper.find(Title)).toExist();
    expect(wrapper.find(CoreText)).toHaveLength(2);
  });

  it('calls onClose function when button is clicked', () => {
    const mockOnClose = jest.fn();
    const { wrapper } = setup({ onClose: mockOnClose });
    wrapper.find(Button).simulate('click');
    expect(mockOnClose).toHaveBeenCalledTimes(1);
  });
});
