import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { Title } from 'twitch-core-ui';
import type { EnforcementType } from '../__generated__/EnforcementsSelector_enforcementsInfoForAppeals_enforcements.graphql';

type EnforcementTitleProps = {
  suspensionDuration?: number;
  type: EnforcementType;
};

export const EnforcementTitle: FC<EnforcementTitleProps> = ({
  suspensionDuration,
  type,
}) => {
  const { formatMessage } = useIntl();
  const title = () => {
    switch (type) {
      case 'Suspension':
        switch (suspensionDuration) {
          case -1:
            return formatMessage('Indefinite suspension', 'Moonbase');
          case undefined:
            return formatMessage('Suspension', 'Moonbase');
          default:
            // 60s in a minute. 60 mins per hour. 24hrs in a day.
            const timeInDays = Math.round(suspensionDuration / 60 / 60 / 24);
            return formatMessage(
              '{timeInDays, plural, one {# day suspension} other {# day suspension}}',
              { timeInDays },
              'Moonbase',
            );
        }
      case 'ForcedUsernameReset':
        return formatMessage('Username Reset', 'Moonbase');
      case 'Warning':
        return formatMessage('Warning', 'Moonbase');
      case 'LivestreamEnforcement':
        return formatMessage('Livestream enforcement', 'Moonbase');
      default:
        return formatMessage('Enforcement', 'Moonbase');
    }
  };

  return <Title>{title()}</Title>;
};

EnforcementTitle.displayName = 'EnforcementTitle';
