import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Title } from 'twitch-core-ui';
import { EnforcementTitle } from '.';

describe(EnforcementTitle, () => {
  const setup = createShallowWrapperFactory(EnforcementTitle, () => ({
    suspensionDuration: 1000,
    type: 'Suspension',
  }));

  it('renders as expected with type suspension and a known suspension duration', () => {
    const { wrapper } = setup();
    expect(wrapper.find(Title)).toExist();
    expect(wrapper.find(Title).html()).toContain('day suspension');
  });

  it('renders as expected with indefinite suspension', () => {
    const { wrapper } = setup({ suspensionDuration: -1, type: 'Suspension' });
    expect(wrapper.find(Title)).toExist();
    expect(wrapper.find(Title).html()).toContain('Indefinite suspension');
  });

  it('renders as expected with type warning', () => {
    const { wrapper } = setup({ type: 'Warning' });
    expect(wrapper.find(Title)).toExist();
    expect(wrapper.find(Title).html()).toContain('Warning');
  });

  it('renders as expected with type forced username reset', () => {
    const { wrapper } = setup({ type: 'ForcedUsernameReset' });
    expect(wrapper.find(Title)).toExist();
    expect(wrapper.find(Title).html()).toContain('Username Reset');
  });

  it('renders as expected with unknown enforcement type', () => {
    const { wrapper } = setup({ type: 'UNKNOWN' });
    expect(wrapper.find(Title)).toExist();
    expect(wrapper.find(Title).html()).toContain('Enforcement');
  });

  it('renders as expected with no suspension duration', () => {
    const { wrapper } = setup({ suspensionDuration: undefined });
    expect(wrapper.find(Title)).toExist();
  });
});
