import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { Pill, PillType, TextTransform } from 'twitch-core-ui';
import type { AppealStatus } from '../__generated__/EnforcementsSelector_enforcementsInfoForAppeals_enforcements.graphql';

type StatusPillProps = {
  appealStatus: AppealStatus;
};

export const StatusPill: FC<StatusPillProps> = ({ appealStatus }) => {
  const { formatMessage } = useIntl();
  switch (appealStatus) {
    case 'Accepted':
      return (
        <Pill
          label={formatMessage('Accepted', 'Moonbase')}
          transform={TextTransform.Uppercase}
          type={PillType.Success}
        />
      );
    case 'Rejected':
      return (
        <Pill
          label={formatMessage('Rejected', 'Moonbase')}
          transform={TextTransform.Uppercase}
          type={PillType.Alert}
        />
      );
    case 'PendingReview':
      return (
        <Pill
          label={formatMessage('Pending', 'Moonbase')}
          transform={TextTransform.Uppercase}
          type={PillType.Warn}
        />
      );
    default:
      return null;
  }
};

StatusPill.displayName = 'StatusPill';
