import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Pill, PillType } from 'twitch-core-ui';
import { StatusPill } from '.';

describe(StatusPill, () => {
  const setup = createShallowWrapperFactory(StatusPill, () => ({
    appealStatus: 'NeverAppealed',
  }));

  it('shows no appeal status pill if user never appeals', () => {
    const { wrapper } = setup();
    expect(wrapper.find(Pill)).not.toExist();
  });

  it('shows appeal status pill if user has accepted appeal', () => {
    const { wrapper } = setup({ appealStatus: 'Accepted' });
    expect(wrapper.find(Pill)).toExist();
    expect(wrapper.find(Pill).props().type).toEqual(PillType.Success);
  });

  it('shows appeal status pill if user has pending appeal', () => {
    const { wrapper } = setup({ appealStatus: 'PendingReview' });
    expect(wrapper.find(Pill)).toExist();
    expect(wrapper.find(Pill).props().type).toEqual(PillType.Warn);
  });

  it('shows appeal status pill if user has rejected appeal', () => {
    const { wrapper } = setup({ appealStatus: 'Rejected' });
    expect(wrapper.find(Pill)).toExist();
    expect(wrapper.find(Pill).props().type).toEqual(PillType.Alert);
  });
});
