import type { FormEvent } from 'react';
import { useRefetchableFragment } from 'react-relay/hooks';
import { createMountWrapperFactory, mockChangeEvent } from 'tachyon-test-utils';
import { CoreText, Pagination, Selectable, Title } from 'twitch-core-ui';
import { homepageQuery } from '../../test-mocks';
import type { EnforcementsSelector_enforcementsInfoForAppeals_enforcements } from './__generated__/EnforcementsSelector_enforcementsInfoForAppeals_enforcements.graphql';
import { EnforcementsSelector } from '.';

const mockRefetch = jest.fn();
jest.mock('react-relay/hooks', () => ({
  ...jest.requireActual('react-relay/hooks'),
  useRefetchableFragment: jest.fn(() => [{}, mockRefetch]),
}));
const mockUseRefetchableFragment = useRefetchableFragment as jest.Mock;

const enforcementsSelectorQuery: EnforcementsSelector_enforcementsInfoForAppeals_enforcements =
  {
    ' $refType': 'EnforcementsSelector_enforcementsInfoForAppeals_enforcements',
    enforcementsInfoForAppeals: {
      enforcements: [
        {
          appealStatus: 'PendingReview',
          appealable: true,
          createdAt: 'createdAt',
          detailedReason: 'detailedReason',
          enforcementType: 'Suspension',
          id: '1',
          medium: 'medium',
          suspension: {
            duration: 1000,
            isPermanent: true,
          },
        },
        {
          appealStatus: 'NeverAppealed',
          appealable: true,
          createdAt: 'createdAt',
          detailedReason: 'detailedReason',
          enforcementType: 'Warning',
          id: '2',
          medium: 'medium',
          suspension: null,
        },
      ],
      total: 2,
    },
  };

describe(EnforcementsSelector, () => {
  const setup = createMountWrapperFactory(EnforcementsSelector, () => ({
    currentPage: 1,
    enforcementsRef: homepageQuery,
    onChange: (_: FormEvent<HTMLInputElement>) => null,
    onClickPagination: (_: number) => null,
    selectedEnforcement: '',
    selectedEnforcementID: '2',
  }));

  it('renders as expected', () => {
    mockUseRefetchableFragment.mockImplementationOnce(() => [
      enforcementsSelectorQuery,
      mockRefetch,
    ]);

    const { wrapper } = setup();
    expect(wrapper.find(Selectable)).toExist();
    expect(wrapper.find(CoreText)).toExist();
    expect(wrapper.find(Title)).toExist();
    expect(wrapper.find(Pagination)).toExist();
  });

  it('on clicking Selectable, calls onChange', () => {
    mockUseRefetchableFragment.mockImplementationOnce(() => [
      enforcementsSelectorQuery,
      mockRefetch,
    ]);

    const mockOnChange = jest.fn();
    const { wrapper } = setup({ onChange: mockOnChange });
    wrapper.find(Selectable).last().props().onChange?.(mockChangeEvent('2'));
    expect(mockOnChange).toHaveBeenCalledTimes(1);
  });
});
