import type { FC } from 'react';
import {
  AlignItems,
  BorderRadius,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  Placeholder,
  Selectable,
  SelectableType,
} from 'twitch-core-ui';

export type EnforcementsSelectorPlaceholderProps = {
  numberEnforcements?: number;
};

export const EnforcementsSelectorPlaceholder: FC<EnforcementsSelectorPlaceholderProps> =
  ({ numberEnforcements = 3 }) => {
    return (
      <>
        <Layout>
          {Array.from({ length: numberEnforcements }, (_, i) => (
            <Layout key={i} margin={{ y: 1 }}>
              <Selectable
                borderRadius={BorderRadius.Large}
                checked={false}
                disabled
                name="category-selector-radio"
                type={SelectableType.Radio}
              >
                <Layout
                  breakpointExtraSmall={{
                    alignItems: AlignItems.Center,
                    flexDirection: FlexDirection.Row,
                    justifyContent: JustifyContent.Between,
                    padding: { x: 2, y: 1 },
                  }}
                  display={Display.Flex}
                  flexDirection={FlexDirection.Column}
                  padding={{ x: 1, y: 1 }}
                >
                  <Layout
                    display={Display.Flex}
                    flexDirection={FlexDirection.Column}
                  >
                    {/* title */}
                    <Placeholder height={24} width={120} />
                    <Layout padding={{ bottom: 0.5, top: 1 }}>
                      {/* enforcement type */}
                      <Placeholder height={16} width={160} />
                    </Layout>
                    {/* date */}
                    <Placeholder lineCount={1} />
                  </Layout>
                  <Layout
                    breakpointExtraSmall={{ padding: { y: 1 } }}
                    padding={{ top: 1 }}
                  >
                    <Placeholder height={20} width={72} />
                  </Layout>
                </Layout>
              </Selectable>
            </Layout>
          ))}
        </Layout>
        <Layout
          display={Display.Flex}
          justifyContent={JustifyContent.Center}
          margin={{ top: 2 }}
        >
          {/* pagination */}
          <Placeholder height={14} width={120} />
        </Layout>
      </>
    );
  };

EnforcementsSelectorPlaceholder.displayName = 'EnforcementsSelectorPlaceholder';
