import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Placeholder } from 'twitch-core-ui';
import { EnforcementsSelectorPlaceholder } from '.';

const numPlaceholdersPerEnforcement = 4;

describe(EnforcementsSelectorPlaceholder, () => {
  const setup = createShallowWrapperFactory(
    EnforcementsSelectorPlaceholder,
    () => ({
      numberEnforcements: 3,
    }),
  );

  it('renders as expected with correct number of placeholders', () => {
    const { wrapper } = setup({ numberEnforcements: 2 });
    expect(wrapper.find(Placeholder)).toHaveLength(
      // should show placeholders for correct number of enforcements + 1 placeholder for pagination
      2 * numPlaceholdersPerEnforcement + 1,
    );
  });

  it('renders as expected with default number of placeholders', () => {
    const { wrapper } = setup();
    expect(wrapper.find(Placeholder)).toHaveLength(
      // default to 3 enforcements + 1 placeholder for pagination
      3 * numPlaceholdersPerEnforcement + 1,
    );
  });
});
