import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CheckBox } from 'twitch-core-ui';
import { homepageQuery } from '../../test-mocks';
import { TermsAndConditionsCheckbox } from '.';

describe(TermsAndConditionsCheckbox, () => {
  const setup = createShallowWrapperFactory(TermsAndConditionsCheckbox, () => ({
    checked: false,
    onChange: () => null,
    userInfo: homepageQuery.userInfo,
  }));

  it('renders as expected with checkbox unchecked', () => {
    const { wrapper } = setup();
    expect(wrapper.find(CheckBox)).toExist();
    expect(wrapper.find(CheckBox).props().checked).toEqual(false);
  });

  it('calls onChange when terms and conditions checkbox is ticked', () => {
    const mockOnChange = jest.fn();
    const { wrapper } = setup({ onChange: mockOnChange });
    wrapper.find(CheckBox).simulate('change');
    expect(mockOnChange).toHaveBeenCalledTimes(1);
  });
});
