import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import {
  CoreText,
  Display,
  FlexDirection,
  Layout,
  Title,
  TitleSize,
} from 'twitch-core-ui';

type TitleAndContextProps = {
  isSuspended: boolean;
};

export const TitleAndContext: FC<TitleAndContextProps> = ({ isSuspended }) => {
  const { formatMessage } = useIntl();
  return (
    <Layout
      as="section"
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
    >
      <Layout padding={{ bottom: 1 }}>
        <Title size={TitleSize.Large}>
          {isSuspended
            ? formatMessage('Your account is suspended.', 'Moonbase')
            : formatMessage('This is the Appeals Portal.', 'Moonbase')}
        </Title>
      </Layout>
      <CoreText>
        {isSuspended
          ? formatMessage(
              'If you believe that this is an error, you may appeal here. Please note that abusing our appeals process, or attempting to evade restrictions placed on your account, may result in additional penalties, up to and including indefinite suspension.',
              'Moonbase',
            )
          : formatMessage(
              'You may appeal enforcements against your account here. Please note that abusing our appeals process, or attempting to evade restrictions placed on your account, may result in additional penalties, up to and including indefinite suspension.',
              'Moonbase',
            )}
      </CoreText>
    </Layout>
  );
};

TitleAndContext.displayName = 'TitleAndContext';
