import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreText, Title } from 'twitch-core-ui';
import { TitleAndContext } from '.';

describe(TitleAndContext, () => {
  const setup = createShallowWrapperFactory(TitleAndContext, () => ({
    isSuspended: true,
  }));

  it('renders as expected with correct copy if user is suspended', () => {
    const { wrapper } = setup();
    expect(wrapper.find(Title)).toExist();
    expect(wrapper.find(Title).html()).toContain('Your account is suspended');
    expect(wrapper.find(CoreText)).toExist();
    expect(wrapper.find(CoreText).html()).toContain(
      'If you believe that this is an error, you may appeal here.',
    );
  });

  it('renders as expected with correct copy if user is not suspended', () => {
    const { wrapper } = setup({ isSuspended: false });
    expect(wrapper.find(Title)).toExist();
    expect(wrapper.find(Title).html()).toContain('This is the Appeals Portal');
    expect(wrapper.find(CoreText)).toExist();
    expect(wrapper.find(CoreText).html()).toContain(
      'You may appeal enforcements against your account here.',
    );
  });
});
