import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import {
  Column,
  FormGroup,
  Grid,
  Input,
  InputType,
  Layout,
} from 'twitch-core-ui';
import type { Homepage_QueryResponse } from '../../__generated__/Homepage_Query.graphql';

type UserAccountDetailsProps = {
  userInfo: Homepage_QueryResponse['userInfo'];
};

export const UserAccountDetails: FC<UserAccountDetailsProps> = ({
  userInfo,
}) => {
  const { formatMessage } = useIntl();

  const userDetailField = (label: string, value?: string | null) =>
    value && (
      <Layout fullWidth margin={{ y: 1 }}>
        <FormGroup label={label}>
          <Input disabled type={InputType.Text} value={value} />
        </FormGroup>
      </Layout>
    );

  return (
    <Layout margin={{ y: 1 }}>
      <Grid>
        <Column cols={{ default: 12, sm: 4 }}>
          {userDetailField(
            formatMessage('Username', 'Moonbase'),
            userInfo?.login,
          )}
        </Column>
        <Column cols={{ default: 12, sm: 4 }}>
          {userDetailField(formatMessage('Email', 'Moonbase'), userInfo?.email)}
        </Column>
        <Column cols={{ default: 12, sm: 4 }}>
          {userDetailField(
            formatMessage('Phone Number', 'Moonbase'),
            userInfo?.phoneNumber,
          )}
        </Column>
      </Grid>
    </Layout>
  );
};

UserAccountDetails.displayName = 'UserAccountDetails';
