import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Input } from 'twitch-core-ui';
import { homepageQuery } from '../../test-mocks';
import { UserAccountDetails } from '.';

describe(UserAccountDetails, () => {
  const setup = createShallowWrapperFactory(UserAccountDetails, () => ({
    userInfo: homepageQuery.userInfo,
  }));

  it('renders all 3 fields as expected when we have a value for each of them', () => {
    const { wrapper } = setup();
    expect(wrapper.find(Input)).toHaveLength(3);
  });

  it('only renders fields for which we have a value', () => {
    let { wrapper } = setup({
      userInfo: {
        email: 'email',
        login: 'username',
        phoneNumber: undefined,
      },
    });
    expect(wrapper.find(Input)).toHaveLength(2);

    wrapper = setup({
      userInfo: {
        email: undefined,
        login: 'username',
        phoneNumber: undefined,
      },
    }).wrapper;
    expect(wrapper.find(Input)).toHaveLength(1);

    wrapper = setup({
      userInfo: {
        email: undefined,
        login: undefined,
        phoneNumber: undefined,
      },
    }).wrapper;
    expect(wrapper.find(Input)).toHaveLength(0);
  });
});
