import type { FC, ReactChild } from 'react';
import { useCustomTracking } from 'tachyon-event-tracker';
import { useIntl } from 'tachyon-intl';
import { GlowCoolCatSvg } from 'tachyon-more-ui';
import {
  AlignItems,
  CoreLink,
  CoreText,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  TextAlign,
  TextType,
  Title,
} from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../../routing';
import type { SpadeViewedNoEnforcementsLandingPageEvent } from '../../../../utils';
import { ViewedNoEnforcementsLandingPageEvent } from '../../../../utils';
import { NAVBAR_HEIGHT } from '../../../common';
import type { Homepage_QueryResponse } from '../__generated__/Homepage_Query.graphql';

type NoEnforcementsLandingPageProps = {
  userInfo: Homepage_QueryResponse['userInfo'];
};

const creatorDashboardLink = (children: ReactChild) => (
  <CoreLink
    linkTo="/deferToRenderLink"
    renderLink={renderTachyonLink({
      route: RouteName.External,
      routeParams: { href: 'https://dashboard.twitch.tv/' },
    })}
  >
    {children}
  </CoreLink>
);

const boldUsername = (children: ReactChild) => (
  <CoreText bold type={TextType.Span}>
    {children}
  </CoreText>
);

export const NoEnforcementsLandingPage: FC<NoEnforcementsLandingPageProps> = ({
  userInfo,
}) => {
  const { formatMessage } = useIntl();
  const trackEvent =
    useCustomTracking<SpadeViewedNoEnforcementsLandingPageEvent>();

  trackEvent({
    event: ViewedNoEnforcementsLandingPageEvent.Name,
    user_id: userInfo?.id ?? '',
    user_username: userInfo?.login ?? '',
  });

  return (
    <Layout
      alignItems={AlignItems.Center}
      as="main"
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      justifyContent={JustifyContent.Center}
      margin={2}
      minHeight={`calc(100vh - ${NAVBAR_HEIGHT})`}
    >
      <Layout maxWidth="15rem">
        <GlowCoolCatSvg />
      </Layout>
      <Layout margin={{ y: 1 }}>
        <Title>{formatMessage('This is the Appeals Portal', 'Moonbase')}</Title>
      </Layout>

      <Layout
        alignItems={AlignItems.Center}
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        justifyContent={JustifyContent.Center}
        maxWidth="30rem"
      >
        <Layout margin={{ bottom: 2 }} textAlign={TextAlign.Center}>
          <CoreText>
            {userInfo?.login
              ? formatMessage(
                  'Hey <x:block>{username}</x:block>, you have never received an enforcement. Keep being awesome.',
                  {
                    username: userInfo.login,
                    'x:block': (children) => boldUsername(children),
                  },
                  'Moonbase',
                )
              : formatMessage(
                  'You have never received an enforcement. Keep being awesome.',
                  'Moonbase',
                )}
          </CoreText>
        </Layout>
        <Layout margin={{ bottom: 2 }} textAlign={TextAlign.Center}>
          <CoreText>
            {formatMessage(
              'If you would like to appeal a DMCA notice, please login to <x:link>Creator Dashboard</x:link> to see your DMCA claims and learn how to file a counternotice.',
              {
                'x:link': (children) => creatorDashboardLink(children),
              },
              'Moonbase',
            )}
          </CoreText>
        </Layout>
      </Layout>
    </Layout>
  );
};

NoEnforcementsLandingPage.displayName = 'NoEnforcementsLandingPage';
