import { GlowCoolCatSvg } from 'tachyon-more-ui';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreText, Title } from 'twitch-core-ui';
import { homepageQuery } from '../test-mocks';
import { NoEnforcementsLandingPage } from '.';

describe(NoEnforcementsLandingPage, () => {
  const setup = createShallowWrapperFactory(NoEnforcementsLandingPage, () => ({
    userInfo: homepageQuery.userInfo,
  }));

  it('renders as expected', () => {
    const { wrapper } = setup();
    expect(wrapper.find(GlowCoolCatSvg)).toExist();
    expect(wrapper.find(Title)).toExist();
    expect(wrapper.find(Title).html()).toContain('This is the Appeals Portal');
    expect(wrapper.find(CoreText)).toHaveLength(2);
  });
});
