import type { FragmentRefs } from 'relay-runtime';
import type { Homepage_QueryResponse } from './__generated__/Homepage_Query.graphql';

const enforcementRefs: FragmentRefs<'EnforcementsSelector_enforcementsInfoForAppeals_enforcements'> =
  {
    EnforcementsSelector_enforcementsInfoForAppeals_enforcements: true,
  };

const userInfoRefs: FragmentRefs<'TopNavDropDownMenu_userInfo'> = {
  TopNavDropDownMenu_userInfo: true,
};

export const homepageQuery: Homepage_QueryResponse = {
  ' $fragmentRefs': enforcementRefs,
  enforcementsInfoForAppeals: {
    total: 1,
  },
  userInfo: {
    ' $fragmentRefs': userInfoRefs,
    displayName: 'displayName',
    email: 'email',
    emailVerified: false,
    id: 'id',
    isSuspended: false,
    language: 'en-US',
    login: 'login',
    phoneNumber: 'phoneNumber',
    profileImageURL: 'profileImageURL',
  },
};
