import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { AppealsPortal } from './AppealsPortal';
import { NoEnforcementsLandingPage } from './NoEnforcementsLandingPage';
import { homepageQuery } from './test-mocks';
import { Homepage } from '.';

describe(Homepage, () => {
  const setup = createShallowWrapperFactory(Homepage, () => ({
    ...homepageQuery,
  }));

  it('renders AppealPortal when user has at least 1 enforcement', () => {
    const { wrapper } = setup({ enforcementsInfoForAppeals: { total: 1 } });
    expect(wrapper.find(AppealsPortal)).toExist();
  });

  it('renders NoEnforcementsLandingPage when user has received 0 enforcements', () => {
    const { wrapper } = setup({ enforcementsInfoForAppeals: { total: 0 } });
    expect(wrapper.find(NoEnforcementsLandingPage)).toExist();
  });
});
