import { useIntl } from 'tachyon-intl';
import type { TachyonPage } from 'tachyon-next-types';
import {
  defaultPageviewTracking,
  notFoundGetInitialProps,
} from 'tachyon-page-utils';
import { AlignItems, Display, JustifyContent, Layout } from 'twitch-core-ui';
import { Error, NAVBAR_HEIGHT, TopNav } from '../../common';

// istanbul ignore next: trivial
export const NotFound: TachyonPage = () => {
  const { formatMessage } = useIntl();
  return (
    <>
      <TopNav />
      <Layout
        alignItems={AlignItems.Center}
        display={Display.Flex}
        justifyContent={JustifyContent.Center}
        minHeight={`calc(100vh - ${NAVBAR_HEIGHT})`}
        padding={2}
      >
        <Error
          description={formatMessage(
            'The page you requested does not exist.',
            'Moonbase',
          )}
          title={formatMessage('Error 404', 'Moonbase')}
        />
      </Layout>
    </>
  );
};

NotFound.displayName = 'NotFound';
NotFound.pageviewTracking = defaultPageviewTracking;

// istanbul ignore next: trivial
NotFound.getInitialProps = (ctx) =>
  notFoundGetInitialProps({ package: 'moonbase' }, ctx);
