import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Error } from '../../common';
import { NotFound } from '.';

describe(NotFound, () => {
  const setup = createShallowWrapperFactory(NotFound);

  it('renders as expected', () => {
    const { wrapper } = setup();
    expect(wrapper.find(Error)).toExist();
    expect(wrapper.find(Error).props().description).toContain(
      'page you requested does not exist',
    );
    expect(wrapper.find(Error).props().title).toContain('Error 404');
  });
});
