import { useDynamicSettings } from 'tachyon-dynamic-settings';
import { GlowGearSvg } from 'tachyon-more-ui';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreText, Title } from 'twitch-core-ui';
import { LoginButton } from '../../common';
import { OAuth } from '.';

jest.mock('tachyon-dynamic-settings', () => ({
  useDynamicSettings: jest.fn(() => ({ moonbaseDisabled: false })),
}));
const mockUseDynamicSettings = useDynamicSettings as jest.Mock;

describe(OAuth, () => {
  const setup = createShallowWrapperFactory(OAuth);

  it('renders as expected', () => {
    const { wrapper } = setup();
    expect(wrapper.find(GlowGearSvg)).toExist();
    expect(wrapper.find(Title)).toExist();
    expect(wrapper.find(Title).html()).toContain('Appeals Portal');
    expect(wrapper.find(CoreText)).toExist();
    expect(wrapper.find(CoreText).html()).toContain(
      'To view your enforcements and submit an appeal, please log in.',
    );
    expect(wrapper.find(LoginButton)).toExist();
  });

  it('empty renders when moonbaseDisabled is true', () => {
    mockUseDynamicSettings.mockImplementationOnce(() => ({
      moonbaseDisabled: true,
    }));
    const { wrapper } = setup();

    expect(wrapper).toBeEmptyRender();
  });
});
