import type { FC } from 'react';
import type { AgentInfo, EnvironmentRootProps } from 'tachyon-environment';
import { EnvironmentRoot, Platform, isMobileWeb } from 'tachyon-environment';
import { CLIENT_APP } from '../../../../../config';

type MoonbaseEnvironmentRootProps = Pick<
  EnvironmentRootProps['common'],
  'appEnvironment' | 'language'
>;

const PLATFORM = (agentInfo: AgentInfo): Platform =>
  isMobileWeb(agentInfo) ? Platform.MobileWeb : Platform.Web;

// istanbul ignore next: trivial
export const MoonbaseEnvironmentRoot: FC<MoonbaseEnvironmentRootProps> = ({
  appEnvironment,
  children,
  language,
}) => {
  return (
    <EnvironmentRoot
      children={children}
      common={{
        appEnvironment,
        appVersion: process.env.BUILD_ID,
        clientApp: CLIENT_APP,
        language,
        platform: PLATFORM,
      }}
      networkStatusDebounceWait={null}
    />
  );
};

MoonbaseEnvironmentRoot.displayName = 'MoonbaseEnvironmentRoot';
