import type { FC } from 'react';
import { useMemo } from 'react';
import { useDynamicSettings } from 'tachyon-dynamic-settings';
import type { EventReporterRootProps } from 'tachyon-event-reporter';
import { EventReporterRoot } from 'tachyon-event-reporter';
import type { MoonbaseDynamicSettings } from '../../../../../config';
import { SPADE_BATCH_WINDOW_MS } from '../../../../../config';

// istanbul ignore next: trivial
export const MoonbaseEventReporterRoot: FC = ({ children }) => {
  const { spadeUrl } = useDynamicSettings<MoonbaseDynamicSettings>();

  const spadeOpts: EventReporterRootProps['spade'] = useMemo(
    () => ({ batchWindowMs: SPADE_BATCH_WINDOW_MS, spadeUrl }),
    [spadeUrl],
  );

  return <EventReporterRoot children={children} spade={spadeOpts} />;
};

MoonbaseEventReporterRoot.displayName = 'MoonbaseEventReporterRoot';
