import type { FC } from 'react';
import { useMemo } from 'react';
import { RelayEnvironmentProvider } from 'react-relay/hooks';
import { useCurrentUser } from 'tachyon-auth';
import { useCustomTracking } from 'tachyon-event-tracker';
import type { FetchQueryOpts, RecordMap, RelayEvent } from 'tachyon-relay';
import { initEnvironment } from 'tachyon-relay';
import { getDeviceIDInBrowser, isBrowser } from 'tachyon-utils';

type MoonbaseRelayEnvironmentRootProps = {
  fetchQueryOpts: FetchQueryOpts;
  records: RecordMap | undefined;
};

export const MoonbaseRelayEnvironmentRoot: FC<MoonbaseRelayEnvironmentRootProps> =
  ({ children, fetchQueryOpts, records }) => {
    const { getAuthToken, logout } = useCurrentUser();
    const trackEvent = useCustomTracking<RelayEvent>();

    const environment = useMemo(() => {
      const opts = isBrowser()
        ? {
            fetchQueryOpts: {
              ...fetchQueryOpts,
              authorization: {
                token: getAuthToken,
                unauthorizedHandler: logout,
              },
              deviceId: getDeviceIDInBrowser(),
              onEvent: trackEvent,
            },
            records,
          }
        : { fetchQueryOpts, records };

      return initEnvironment(opts);
    }, [fetchQueryOpts, getAuthToken, logout, records, trackEvent]);

    return (
      <RelayEnvironmentProvider children={children} environment={environment} />
    );
  };

MoonbaseRelayEnvironmentRoot.displayName = 'MoonbaseRelayEnvironmentRoot';
