import { Pageview } from 'tachyon-event-tracker';
import { useIntl } from 'tachyon-intl';
import type { TachyonPage } from 'tachyon-next-types';
import type { ErrorInitialProps } from 'tachyon-page-utils';
import {
  defaultPageviewTracking,
  errorGetInitialProps,
} from 'tachyon-page-utils';
import { AlignItems, Display, JustifyContent, Layout } from 'twitch-core-ui';
import { Error, NAVBAR_HEIGHT, TopNav } from '../../common';

// istanbul ignore next: trivial
export const MoonbaseError: TachyonPage<ErrorInitialProps> = (props) => {
  const { formatMessage } = useIntl();

  let title = formatMessage('Oops!', 'Moonbase');
  let description = formatMessage(
    'Encountered an unexpected error. You may want refresh the page and try again.',
    'Moonbase',
  );

  if (props.statusCode) {
    title = formatMessage(
      'Error {statusCode}',
      { statusCode: props.statusCode },
      'Moonbase',
    );

    if (props.statusCode === 404) {
      description = formatMessage(
        'The page you requested does not exist.',
        'Moonbase',
      );
    }
  }

  return (
    <>
      <Pageview />
      <TopNav />
      <Layout
        alignItems={AlignItems.Center}
        display={Display.Flex}
        fullWidth
        height={`calc(100vh - ${NAVBAR_HEIGHT})`}
        justifyContent={JustifyContent.Center}
      >
        <Error description={description} title={title} />
      </Layout>
    </>
  );
};

MoonbaseError.displayName = 'MoonbaseError';
MoonbaseError.pageviewTracking = defaultPageviewTracking;

// istanbul ignore next: trivial
MoonbaseError.getInitialProps = (ctx) =>
  errorGetInitialProps({ package: 'moonbase' }, ctx);
