import type { ExperimentBucket } from 'tachyon-experiments';
import type { IntlData } from 'tachyon-intl';

/**
 * Extra fields to attach to the request object to transport from the Node app
 * handler to the Next client server.
 */
export type MoonbaseRequestExtensions = {
  /**
   * Device id captured from cookie or generated on the server
   */
  readonly deviceId: string | undefined;
  /**
   * Experiment bucket ID for the current user.
   */
  readonly experimentBucket: ExperimentBucket | undefined;
  /**
   * The intlData that was selected as part of the TachyonIntlServer loading process.
   */
  readonly intlData: IntlData;
};
