const allowedProtocols = ['http:', 'https:'];

/**
 * Ensures that link target is both valid and using a safe protocol
 */
export function ensureValidLinkAndProtocol(href: string): string | undefined {
  try {
    if (allowedProtocols.includes(new URL(href).protocol)) {
      return href;
    }
  } catch {
    // invalid link detected by URL constructor
  }
  return undefined;
}
