import { Enum } from 'tachyon-utils';
import { RouteLinkPathnames } from '../routes';

/**
 * Returns an array of pathnames that are dynamic.
 */
export function dynamicPathnames(): string[] {
  const pathnames = Enum.values(RouteLinkPathnames);

  // This avoid duplicates since some of our routes alias to the same pathname.
  const dynamicPaths = pathnames.reduce<Set<string>>((agg, pathname) => {
    if (pathname.includes('[')) {
      agg.add(pathname);
    }
    return agg;
  }, new Set());

  return Array.from(dynamicPaths);
}
