import { RouteName, pathnameFromRouteName } from '../routes';
import { linkPartsForRouteName } from '.';

describe(linkPartsForRouteName, () => {
  it('creates a valid asPath for a static route', () => {
    expect(linkPartsForRouteName({ route: RouteName.HealthCheck })).toEqual({
      href: pathnameFromRouteName(RouteName.HealthCheck),
    });
  });

  it('creates a valid asPath for a static route with query params', () => {
    const query = { baz: ['boo', 'boop'], foo: 'bar' };
    expect(
      linkPartsForRouteName({ route: RouteName.HealthCheck }, query),
    ).toEqual({
      as: `${pathnameFromRouteName(
        RouteName.HealthCheck,
      )}?baz=boo&baz=boop&foo=bar`,
      href: `${pathnameFromRouteName(
        RouteName.HealthCheck,
      )}?baz=boo&baz=boop&foo=bar`,
    });
  });
});
