import { RouteLinkPathnames, RouteName, routeNameFromPathname } from '.';

describe(routeNameFromPathname, () => {
  it.each(Object.entries(RouteLinkPathnames))(
    'returns %s for path %s',
    (routeName: string, pathname: string) => {
      expect(routeNameFromPathname(pathname)).toEqual(routeName);
    },
  );

  it.each(['/foo', '/foo/bar'])(
    `returns ${RouteName.NotFound} for path %s`,
    (pathname: string) => {
      expect(routeNameFromPathname(pathname)).toEqual(RouteName.NotFound);
    },
  );
});
