import { renderHook } from '@testing-library/react-hooks';
import type { AsPathForRouteNameParams } from '../linkPartsForRouteName';
import { linkPartsForRouteName } from '../linkPartsForRouteName';
import { RouteName } from '../routes';
import { mockRouter } from '../test-mocks';
import { useTachyonRouter } from '.';

jest.mock('next/router', () => ({
  useRouter: () => mockRouter,
}));

describe(useTachyonRouter, () => {
  beforeEach(() => {
    mockRouter.push.mockReset();
    mockRouter.replace.mockReset();
    mockRouter.back.mockReset();
    mockRouter.reload.mockReset();
  });

  describe('push forwarding', () => {
    it('works for route without params', () => {
      const { result } = renderHook(() => useTachyonRouter());

      const route: AsPathForRouteNameParams<RouteName.HealthCheck> = {
        route: RouteName.HealthCheck,
      };

      result.current.push(route);
      const { as, href } = linkPartsForRouteName(route);
      expect(mockRouter.push).toHaveBeenCalledTimes(1);
      expect(mockRouter.push).toHaveBeenCalledWith(href, as);
    });
  });

  describe('replace forwarding', () => {
    it('works for route without params', () => {
      const { result } = renderHook(() => useTachyonRouter());

      const route: AsPathForRouteNameParams<RouteName.HealthCheck> = {
        route: RouteName.HealthCheck,
      };

      result.current.replace(route);
      const { as, href } = linkPartsForRouteName(route);
      expect(mockRouter.replace).toHaveBeenCalledTimes(1);
      expect(mockRouter.replace).toHaveBeenCalledWith(href, as);
    });
  });

  describe('back forwarding', () => {
    it('works', () => {
      const { result } = renderHook(() => useTachyonRouter());

      result.current.back();
      expect(mockRouter.back).toHaveBeenCalledTimes(1);
    });
  });

  describe('reload', () => {
    it('works', () => {
      const { result } = renderHook(() => useTachyonRouter());

      result.current.reload();
      expect(mockRouter.push).toHaveBeenCalledTimes(1);
      expect(mockRouter.push).toHaveBeenCalledWith(
        mockRouter.pathname,
        mockRouter.asPath,
        { shallow: false },
      );
    });
  });
});
