export enum SubmitButtonEvent {
  Name = 'clicked_submit_appeal',
}

export interface SpadeSubmitButtonClickEvent {
  current_page: number;
  description: string;
  enforcement_id: string;
  enforcement_index_on_page: number;
  error: string;
  event: SubmitButtonEvent.Name;
  submitted_successfully: boolean;
  total_enforcements: number;
  user_id: string;
  user_username: string;
}

export enum ViewedEnforcementsPageEvent {
  Name = 'viewed_enforcements_page',
}

export type SpadeViewedEnforcementsPageClickEventPerEnforcementData = {
  [key: `enforcement_id_${number}`]: string;
  [key: `enforcement_id_${number}_is_appealable`]: boolean;
};

export interface SpadeViewedEnforcementsPageClickEvent
  extends SpadeViewedEnforcementsPageClickEventPerEnforcementData {
  event: ViewedEnforcementsPageEvent.Name;
  pageNumber: number;
}

export enum ViewedAppealsFormEvent {
  Name = 'viewed_appeals_form',
}

export interface SpadeViewedAppealsFormEvent {
  event: ViewedAppealsFormEvent.Name;
  total_enforcements: number;
  user_id: string;
  user_username: string;
}

export enum ClickLoginButtonEvent {
  Name = 'click_login_button',
}

export interface SpadeClickLoginButtonEvent {
  event: ClickLoginButtonEvent.Name;
}

export enum ClickLogoutButtonEvent {
  Name = 'click_logout_button',
}

export interface SpadeClickLogoutButtonEvent {
  event: ClickLogoutButtonEvent.Name;
}

export enum ClickedCommunityGuidelinesLinkEvent {
  Name = 'clicked_community_guidelines_link',
}

export interface SpadeClickedCommunityGuidelinesLinkEvent {
  enforcement_id: string;
  event: ClickedCommunityGuidelinesLinkEvent.Name;
  outbound_link: string;
  user_id: string;
  user_username: string;
}

export enum ViewedNoEnforcementsLandingPageEvent {
  Name = 'viewed_no_enforcements_landing_page',
}

export interface SpadeViewedNoEnforcementsLandingPageEvent {
  event: ViewedNoEnforcementsLandingPageEvent.Name;
  user_id: string;
  user_username: string;
}
