# Sky-Map

Tachyon's documentation portal that dynamically pulls in documentation (.md)
files from across the project and presents them in an easy to consume manner
using [Github Pages](https://pages.github.com/).

## Running Locally

**Local Development:**

```sh
$ yarn start
```

Access via: http://localhost:3000/

**Simulating A Static Build:**

```sh
$ yarn prodlike
```

## Running Tests

```sh
$ yarn test
```

## Sky-Map Build / Hosting

When Tachyon's `main` Git branch is updated, the `gh-pages` branch will
automatically be updated with the latest Sky-Map build output through the
[GH Pages Publish](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_SkyMapGHPagesPublish)
Teamcity task.

The output of the build process (specifically `yarn export`) will be at the root
of the repo (`_next/`, `d/`, etc) as required by Github Pages and only exists on
the `gh-pages` branch.

## Architecture

- Uses
  [Next.js Static HTML Export](https://nextjs.org/docs/advanced-features/static-html-export).

- Markdown files are bundled into the application at build time via
  [require.context](https://webpack.js.org/guides/dependency-management/#requirecontext)
  and "exportPathMap" in next.config.js.

- The loaded files' pathnames are then split and parsed within the application
  to generate the side navigation hierarchy on app initialization

- Markdown for a specific page is selected and provided during the
  `getInitialProps` call

- Markdown rendering is handled by
  [React Markdown](https://github.com/rexxars/react-markdown)

- Search is handled by [Lunr](https://lunrjs.com/)

- [Core-UI](https://design.xarth.tv/user-interface/getting-started) is used for
  styling

## Configuring Next Export For GH Pages

Useful doc:
[Deploying a Next.js app into GitHub Pages](https://github.com/zeit/next.js/wiki/Deploying-a-Next.js-app-into-GitHub-Pages).

When we run `yarn export`, we execute a production build (`process.env.NODE_ENV`
is "PRODUCTION"). As a result the following happens:

1. `assetPrefix` in `next.config.js` is set to match the full URL to the root of
   Tachyon project's Github pages index route.
1. We apply the same URL path portion of `assetPrefix` in `utils/appLinks` when
   generating routes and in our link generation helper.

## Using Static Images In Markdown Files

For documentation pages that wish to reference static images that are hosted
locally:

1. Add the image to the Doc Portal's `public/static/` folder.
1. Reference the image using a relative path in your Markdown file:

   ```md
   ![Image Title](../some/relative/path/to/apps/sky-map/public/static/image123.png)
   ```

The Doc Portal's Markdown parser is configured to identify and replace these
relative image paths so that they work as intended when requested in the context
of the portal.
