const { transforms } = require('./env.config');

module.exports = (api) => {
  api.cache.using(() => process.env.NODE_ENV);
  const isTest = api.env('test');

  const presets = ['next/babel'];

  const plugins = [
    [
      'babel-plugin-styled-components',
      // disable displayName and ssr in tests
      { displayName: !isTest, fileName: false, pure: true, ssr: !isTest },
    ],
    ['transform-define', transforms],
  ];

  return { plugins, presets };
};
