const GH_PAGES_PATH_PREFIX = '/pages/emerging-platforms/tachyon';
const isProd = process.env.NODE_ENV === 'production' && !process.env.PRODLIKE;
const nextAssetPrefix = isProd ? GH_PAGES_PATH_PREFIX : '';

// This is used by our find-doc script to build the paths that static exports will be generated to in order to more
// closely emulate that paths that are used in production and make local development more consistent.
const staticRoutePrefix = isProd ? '' : GH_PAGES_PATH_PREFIX;

// Prefix to use when generating links within the app.
const linkPrefix = GH_PAGES_PATH_PREFIX;

const transforms = {
  'process.env.LINK_PREFIX': linkPrefix,
};

module.exports = {
  nextAssetPrefix,
  staticRoutePrefix,
  transforms,
};
