const { resolve } = require('path');
const { cwd } = require('process');
const withBundleAnalyzer = require('@next/bundle-analyzer')({
  enabled: !!process.env.ANALYZE,
});
const withFonts = require('next-fonts');
const { buildDocToPathMapping } = require('./dist/find-doc-pages');
const { nextAssetPrefix } = require('./env.config');

module.exports = withBundleAnalyzer(
  withFonts({
    webpack5: false,
    webpack(config, options) {
      // set up aliases
      const alias = config.resolve.alias || {};

      // react-router isn't used by Tachyon apps but is required by core-ui;
      // only necessary because of unused transient dependencies related to
      // latency components that aren't tree-shaken on the server
      config.resolve.alias = {
        ...alias,
        'react-router': 'tachyon-noop',
        'react-router-dom': 'tachyon-noop',
      };

      return config;
    },

    // Used for `next export`, see: https://nextjs.org/docs#static-html-export
    async exportPathMap() {
      return buildDocToPathMapping();
    },

    // to enable generation of `index.html` pages to support GH Pages' trailing slashes
    trailingSlash: true,

    // https://github.com/zeit/next.js/wiki/Deploying-a-Next.js-app-into-GitHub-Pages#extra-step-for-project-page-sites
    assetPrefix: nextAssetPrefix,
  }),
);
