import type { FC } from 'react';
import { memo } from 'react';
import { Prism as SyntaxHighlighter } from 'react-syntax-highlighter';
// eslint-disable-next-line @typescript-eslint/no-unsafe-assignment
const syntaxStyle =
  // eslint-disable-next-line @typescript-eslint/no-var-requires,@typescript-eslint/no-unsafe-member-access
  require('react-syntax-highlighter/dist/cjs/styles/prism/synthwave84').default;

interface CodeBlockProps {
  inline: boolean;
  language?: string;
}

// istanbul ignore next: trivial
/**
 * Config options: https://www.npmjs.com/package/react-syntax-highlighter#props
 */
export const CodeBlockBase: FC<CodeBlockProps> = ({
  children,
  inline,
  language,
}) => {
  if (inline) {
    return <code>{children}</code>;
  }

  // remove terminal newlines to prevent empty lines in blocks
  const code = (children as string[])[0].replace(/\n$/, '');

  return (
    <SyntaxHighlighter
      children={code}
      language={language}
      style={
        syntaxStyle /* eslint-disable-line @typescript-eslint/no-unsafe-assignment */
      }
    />
  );
};
CodeBlockBase.displayName = 'CodeBlockBase';

export const CodeBlock = memo(CodeBlockBase);
