import type { FC } from 'react';
import { Button, ButtonType } from 'twitch-core-ui';
import { filterCoreUiLinkProps } from '../../../utils';

interface LinkOption {
  basePath: string;
  buttonType: ButtonType;
  title: string;
}

export enum GithubLinkType {
  Edit = 'edit',
  View = 'view',
}

export const GithubLinks: Readonly<Record<GithubLinkType, LinkOption>> = {
  [GithubLinkType.Edit]: {
    basePath: 'https://git.xarth.tv/emerging-platforms/tachyon/edit/main',
    buttonType: ButtonType.Primary,
    title: 'Edit Source',
  },
  [GithubLinkType.View]: {
    basePath: 'https://git.xarth.tv/emerging-platforms/tachyon/blob/main',
    buttonType: ButtonType.Text,
    title: 'View Source',
  },
};

export interface GithubLinkProps {
  docFilePath: string;
  type: GithubLinkType;
}

export const GithubLink: FC<GithubLinkProps> = ({ docFilePath, type }) => {
  const { basePath, buttonType, title } = GithubLinks[type];
  const href = `${basePath}${docFilePath}`;

  return (
    <Button
      linkTo="/deferToRenderLink"
      renderLink={(props) => (
        <a {...filterCoreUiLinkProps(props)} href={href} />
      )}
      targetBlank
      variant={buttonType}
    >
      {title}
    </Button>
  );
};

GithubLink.displayName = 'GithubLink';
