import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Button } from 'twitch-core-ui';
import { GithubLink, GithubLinkType, GithubLinks } from '.';

// skipping while we are forced to use renderlink
// eslint-disable-next-line jest/no-disabled-tests
describe.skip(GithubLink, () => {
  const setup = createShallowWrapperFactory(GithubLink, () => ({
    docFilePath: '/readme/doc/path',
    type: GithubLinkType.Edit,
  }));

  it('properly formats an Edit type link', () => {
    expect(setup().wrapper.find(Button)).toHaveProp(
      'linkTo',
      `${GithubLinks[GithubLinkType.Edit].basePath}/readme/doc/path`,
    );
  });

  it('properly formats a View type link', () => {
    expect(
      setup({ type: GithubLinkType.View }).wrapper.find(Button),
    ).toHaveProp(
      'linkTo',
      `${GithubLinks[GithubLinkType.View].basePath}/readme/doc/path`,
    );
  });
});
