import type { Literal } from 'mdast';
import type { FC, ReactElement } from 'react';
import { createElement } from 'react';
import styled from 'styled-components';
import { kebabCase } from 'tachyon-utils';
import { Icon, SVGAsset } from 'twitch-core-ui';

interface HeaderElProps {
  className?: string;
  level: number;
}

const HeaderEl: FC<HeaderElProps> = ({ children, className, level }) =>
  createElement(`h${level}`, { children, className });

HeaderEl.displayName = 'HeaderEl';

// wrapped in styled to allow embedding in CopyAnchor styles
const ScHeaderEl = styled(HeaderEl)``;

export const ScCopyAnchor = styled.a`
  cursor: pointer;
  margin-left: -30px;
  visibility: hidden;
  ${ScHeaderEl}:hover & {
    visibility: visible;
  }
`;

interface HeaderProps {
  children: Array<ReactElement<Literal>>;
  level: number;
}

export const Header: FC<HeaderProps> = ({ children, level }) => {
  const anchor = kebabCase(textFromChildren(children));

  return (
    <ScHeaderEl level={level}>
      <ScCopyAnchor href={`#${anchor}`} id={anchor}>
        <Icon asset={SVGAsset.Link} />
      </ScCopyAnchor>
      {children}
    </ScHeaderEl>
  );
};
Header.displayName = 'Header';

type HeaderChildren = Array<ReactElement | string>;

function textFromChildren(children: HeaderChildren): string {
  return children
    .map((child) =>
      typeof child === 'string'
        ? child
        : // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
          textFromChildren(child.props.children as HeaderChildren),
    )
    .join('');
}
