import { datatype } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Header, ScCopyAnchor } from '.';

describe(Header, () => {
  it('renders linkable anchors (in kebabCase)', () => {
    const setup = createShallowWrapperFactory(Header, () => ({
      children: ['Hello World'] as any,
      level: datatype.number(),
    }));

    const { wrapper } = setup();
    expect(wrapper.find(ScCopyAnchor)).toHaveProp('href', '#hello-world');
  });

  it('works for headers with links in them', () => {
    const setup = createShallowWrapperFactory(Header, () => ({
      children: ['I am a ', { props: { children: ['link'] } }] as any,
      level: datatype.number(),
    }));

    const { wrapper } = setup();
    expect(wrapper.find(ScCopyAnchor)).toHaveProp('href', '#i-am-a-link');
  });
});
