import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { DropDownMenu, Interactable, SearchInput } from 'twitch-core-ui';
import { search } from '../../../utils';
import { Search } from '.';

jest.mock('../../../utils', () => ({
  search: jest.fn(),
}));

const mockSearch = search as jest.Mock;

describe(Search, () => {
  const setup = createShallowWrapperFactory(Search);

  beforeEach(() => {
    jest.resetAllMocks();
    mockSearch.mockReturnValue([]);
  });

  it('renders search results when some are returned', () => {
    const { wrapper } = setup();
    expect(wrapper.find(DropDownMenu)).toHaveProp({ show: false });

    mockSearch.mockReturnValue([
      {
        filePath: '/foo/bar.md',
        title: 'Bar',
        urlPath: '/foo/bar',
      },
      {
        filePath: '/foo/baz.md',
        title: 'Baz',
        urlPath: '/foo/baz',
      },
    ]);

    wrapper
      .find(SearchInput)
      .simulate('change', { currentTarget: { value: 'foo' } });
    expect(wrapper.find(DropDownMenu)).toHaveProp({ show: true });
    expect(wrapper.find(Interactable)).toHaveLength(2);
  });
});
