import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Interactable, SVG } from 'twitch-core-ui';
import {
  formatTopicTitle,
  getDocPageHref,
  getDocPageLink,
} from '../../../../utils';
import { NavSection } from '.';

describe(NavSection, () => {
  const setup = createShallowWrapperFactory(NavSection, () => ({
    pageDocFilePath: '/the-real-derek-t/README.md',
    topic: {
      document: {
        filePath: '/the-real-derek-t/README.md',
        title: formatTopicTitle('the-real-derek-t'),
        urlPath: '/the-real-derek-t/',
      },
      subTopics: {
        'good-looks': { subTopics: {}, title: 'Good Looks' },
        personality: { subTopics: {}, title: 'Personality' },
      },
      title: formatTopicTitle('the-real-derek-t'),
    },
  }));

  // disable while we're forced into using renderLink
  // eslint-disable-next-line jest/no-disabled-tests
  it.skip('wraps the title in a link (with as/linkTo) if the topic has an appPath/docPath', () => {
    const { props, wrapper } = setup();
    expect(wrapper.find(Interactable).first()).toHaveProp({
      as: getDocPageLink(props.topic.document!.urlPath),
      linkTo: getDocPageHref(props.topic.document!.filePath),
    });
  });

  describe('default expansion', () => {
    it('happens when currentDocPath includes topic', () => {
      expect(setup().wrapper).toHaveState({
        expanded: true,
      });
    });

    it('does not happen when currentDocPath does not include topic', () => {
      expect(
        setup({ pageDocFilePath: '/the-fake-derek-t/README.md' }).wrapper,
      ).toHaveState({
        expanded: false,
      });
    });
  });

  it('hides the expand icon and shows the sub-topics when forceExpand is set', () => {
    const { props, wrapper } = setup({ forceExpanded: true });

    expect(wrapper.find(SVG)).not.toExist();
    expect(wrapper.find(NavSection)).toHaveLength(
      Object.keys(props.topic.subTopics).length,
    );
  });
});
