import NextLink from 'next/link';
import type { FC } from 'react';
import { useMemo } from 'react';
import styled from 'styled-components';
import { squareSize } from 'tachyon-more-ui';
import {
  AlignItems,
  Background,
  CoreLink,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  Overflow,
} from 'twitch-core-ui';
import {
  filterCoreUiLinkProps,
  getDocPageLinkRoot,
  getDocPathRootHref,
  getStaticSrc,
  getTopicTree,
} from '../../../utils';
import { NavSection } from './NavSection';

interface SideBarProps {
  currentDocPath: string;
}

const ScSideBar = styled(Layout)`
  width: 23rem;
`;

export const ScTachyonLogo = styled.img`
  ${squareSize({ sizePx: 128 })}
`;

export const SideBar: FC<SideBarProps> = ({ currentDocPath }) => {
  const subTopics = useMemo(() => Object.entries(getTopicTree().subTopics), []);

  return (
    <ScSideBar
      background={Background.Base}
      borderRight
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      fullHeight
    >
      <Layout borderBottom>
        <Layout
          alignItems={AlignItems.Center}
          display={Display.Flex}
          justifyContent={JustifyContent.Center}
          padding={1}
        >
          <CoreLink
            hoverColorInherit
            linkTo="/deferToRenderLink"
            renderLink={(props) => (
              <NextLink as={getDocPageLinkRoot()} href={getDocPathRootHref()}>
                <a {...filterCoreUiLinkProps(props)} />
              </NextLink>
            )}
          >
            <ScTachyonLogo src={getStaticSrc('/images/tachyon-logo.png')} />
          </CoreLink>
        </Layout>
      </Layout>
      <Layout
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        overflow={Overflow.Scroll}
      >
        {subTopics.map<JSX.Element>(([subTopicName, subTopicData]) => (
          <NavSection
            forceExpanded
            key={subTopicName}
            pageDocFilePath={currentDocPath}
            root
            topic={subTopicData}
          />
        ))}
      </Layout>
    </ScSideBar>
  );
};

SideBar.displayName = 'SideBar';
