import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ScTachyonLogo, SideBar } from '.';

jest.mock('../../../utils', () => ({
  ...jest.requireActual('../../../utils'),
  getTopicTree: () => ({ subTopics: {} }),
}));

describe(SideBar, () => {
  const setup = createShallowWrapperFactory(SideBar, () => ({
    currentDocPath: '/doc.md',
  }));

  it('renders an appropriate sized Tachyon Logo', () => {
    const { wrapper } = setup();
    const logo = wrapper.find(ScTachyonLogo);
    expect(logo).toExist();
    expect(logo).toHaveStyleRule('height', '128px');
    expect(logo).toHaveStyleRule('width', '128px');
  });
});
