import App from 'next/app';
import { createGlobalStyle } from 'styled-components';
import { CoreUiSsrRoot } from 'tachyon-more-ui';
import type {
  TachyonAppBaseInitialProps,
  TachyonAppBaseProps,
  TachyonAppContext,
  TachyonAppFC,
} from 'tachyon-next-types';
import {
  Background,
  Display,
  FlexDirection,
  Layout,
  Overflow,
} from 'twitch-core-ui';
import { SideBar } from '../common';

type SkyMapAppInitialProps = TachyonAppBaseInitialProps & {
  currentDocPath: string;
};

type SkyMapAppProps = SkyMapAppInitialProps & TachyonAppBaseProps;

const BodyStyle = createGlobalStyle`
  html,
  body,
  #__next {
    height: 100%;
  }
`;

// istanbul ignore next: trivial
export const SkyMapApp: TachyonAppFC<SkyMapAppInitialProps, SkyMapAppProps> = ({
  Component,
  currentDocPath,
  pageProps,
}) => (
  <CoreUiSsrRoot appRootElementId="__next">
    <BodyStyle />
    <Layout
      background={Background.Base}
      display={Display.Flex}
      flexDirection={FlexDirection.Row}
      fullHeight
      fullWidth
    >
      <Layout
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        flexGrow={0}
        fullHeight
      >
        <SideBar currentDocPath={currentDocPath} />
      </Layout>
      <Layout flexGrow={1} overflow={Overflow.Scroll}>
        <Component {...pageProps} />
      </Layout>
    </Layout>
  </CoreUiSsrRoot>
);

// istanbul ignore next: trivial
SkyMapApp.getInitialProps = async (
  ctx: TachyonAppContext,
): Promise<SkyMapAppInitialProps> => {
  const initialProps = await App.getInitialProps(ctx);

  return {
    ...initialProps,
    currentDocPath: ctx.ctx.query.docFilePath as string,
  };
};

SkyMapApp.displayName = 'SkyMapApp';
