import type {
  DocumentContext,
  DocumentInitialProps,
  DocumentProps,
} from 'next/document';
import Document, { Head, Html, Main, NextScript } from 'next/document';
import { ServerStyleSheet } from 'styled-components';
import { Fonts } from 'tachyon-more-ui';
import { getStaticSrc } from '../../utils';

interface SkyMapDocumentInitialProps extends DocumentInitialProps {}

interface SkyMapDocumentProps
  extends SkyMapDocumentInitialProps,
    DocumentProps {}

/**
 * Root-level React component that is only rendered server-side, see:
 * https://nextjs.org/docs/#custom-document
 */
export class SkyMapDocument extends Document<SkyMapDocumentProps> {
  static async getInitialProps(
    ctx: DocumentContext,
  ): Promise<SkyMapDocumentInitialProps> {
    const sheet = new ServerStyleSheet();
    const originalRenderPage = ctx.renderPage;

    try {
      ctx.renderPage = () =>
        originalRenderPage({
          enhanceApp: (App) => (props) =>
            sheet.collectStyles(<App {...props} />),
        });

      const initialProps = await super.getInitialProps(ctx);
      return {
        ...initialProps,
        styles: sheet.getStyleElement(),
      };
    } finally {
      sheet.seal();
    }
  }

  public render(): JSX.Element {
    return (
      <Html>
        <Head>
          <link
            href={getStaticSrc('/images/tachyon-logo-96x96.png')}
            rel="icon"
          />
          <Fonts />
        </Head>
        <body>
          <Main />
          <NextScript />
        </body>
      </Html>
    );
  }
}
